/*
 * Decompiled with CFR 0.152.
 */
package CP.Keyboard;

import CP.Time.Time;

public final class Keyboard {
    static int[] KPT = new int[256];
    static int[] KP = new int[256];
    static boolean[] KC = new boolean[256];

    public static int KeyWasPressedTime(int n) {
        return KPT[n + 64];
    }

    public static int KeyPressedTime(int n) {
        if (KP[n + 64] == 0) {
            return 0;
        }
        return (int)Time.GetTime() - KP[n + 64];
    }

    public static boolean KeyPressed(int n) {
        return KP[n + 64] != 0;
    }

    public static boolean KeyClicked(int n) {
        return KC[n + 64];
    }

    public static void Update() {
        int n = 0;
        do {
            Keyboard.KC[n] = false;
        } while (255 >= ++n);
        n = 0;
        do {
            Keyboard.KPT[n] = 0;
        } while (255 >= ++n);
    }

    public static void KeyPress(int n) {
        Keyboard.KP[n + 64] = (int)Time.GetTime();
        Keyboard.KC[n + 64] = true;
    }

    public static void KeyRelease(int n) {
        Keyboard.KPT[n + 64] = (int)Time.GetTime() - KP[n + 64];
        Keyboard.KP[n + 64] = 0;
        Keyboard.KC[n + 64] = false;
    }

    public static int KeyDo(int n, boolean bl) {
        if (Keyboard.KeyPressedTime(n) >= 500) {
            if (!bl) {
                Keyboard.KeyRelease(n);
            }
            return 2;
        }
        if (Keyboard.KeyWasPressedTime(n) > 0 && Keyboard.KeyWasPressedTime(n) < 500) {
            return 1;
        }
        return 0;
    }
}

