/*
 * Decompiled with CFR 0.152.
 */
package CP.ScrollBarWidget;

import CP.Config.Config;
import CP.GUI.GUI;
import CP.Keyboard.Keyboard;
import CP.ScrollBarWidget.ScrollBarWidget;
import CP.ScrollBarWidget.ScrollBarWidget_Callback;
import CP.Widgets.Widgets_Widget;
import CP.Windows.Windows;

public final class ScrollBarWidget_ScrollBar
extends Widgets_Widget {
    boolean horizontal;
    int length;
    public int i;
    int min;
    int max;
    Object data;
    ScrollBarWidget_Callback callback;

    public void __copy__(ScrollBarWidget_ScrollBar scrollBarWidget_ScrollBar) {
        this.__copy__((Widgets_Widget)scrollBarWidget_ScrollBar);
        this.horizontal = scrollBarWidget_ScrollBar.horizontal;
        this.length = scrollBarWidget_ScrollBar.length;
        this.i = scrollBarWidget_ScrollBar.i;
        this.min = scrollBarWidget_ScrollBar.min;
        this.max = scrollBarWidget_ScrollBar.max;
        this.data = scrollBarWidget_ScrollBar.data;
        this.callback = scrollBarWidget_ScrollBar.callback;
    }

    public final boolean GrabKeyboard() {
        boolean bl = false;
        if (this.active) {
            if (Keyboard.KeyClicked(-1)) {
                if (this.horizontal) {
                    Windows.CursorUp();
                } else {
                    --this.i;
                    if (this.i < this.min) {
                        this.i = this.min;
                        Windows.CursorUp();
                    } else {
                        this.callback.Invoke(this.i, this.data);
                    }
                }
                bl = true;
            }
            if (Keyboard.KeyClicked(-2)) {
                if (this.horizontal) {
                    Windows.CursorDown();
                } else {
                    ++this.i;
                    if (this.i > this.max) {
                        this.i = this.max;
                        Windows.CursorDown();
                    } else {
                        this.callback.Invoke(this.i, this.data);
                    }
                }
                bl = true;
            }
            if (Keyboard.KeyClicked(-3)) {
                if (this.horizontal) {
                    --this.i;
                    if (this.i < this.min) {
                        this.i = this.min;
                        Windows.CursorLeft();
                    } else {
                        this.callback.Invoke(this.i, this.data);
                    }
                } else {
                    Windows.CursorLeft();
                }
                bl = true;
            }
            if (Keyboard.KeyClicked(-4)) {
                if (this.horizontal) {
                    ++this.i;
                    if (this.i > this.max) {
                        this.i = this.max;
                        Windows.CursorRight();
                    } else {
                        this.callback.Invoke(this.i, this.data);
                    }
                } else {
                    Windows.CursorRight();
                }
                bl = true;
            }
        } else {
            if (Keyboard.KeyClicked(-1)) {
                Windows.CursorUp();
                bl = true;
            }
            if (Keyboard.KeyClicked(-2)) {
                Windows.CursorDown();
                bl = true;
            }
            if (Keyboard.KeyClicked(-3)) {
                Windows.CursorLeft();
                bl = true;
            }
            if (Keyboard.KeyClicked(-4)) {
                Windows.CursorRight();
                bl = true;
            }
        }
        return bl;
    }

    final int ScrollerWidth() {
        if (this.horizontal) {
            return Config.tileSize - Config.ScaleFactor();
        }
        return ((Widgets_Widget)this).Width() - 2 * Config.ScaleFactor();
    }

    final int ScrollerHeight() {
        if (this.horizontal) {
            return ((Widgets_Widget)this).Height() - 2 * Config.ScaleFactor();
        }
        return Config.tileSize - Config.ScaleFactor();
    }

    final int ScrollerShift() {
        int n = this.horizontal ? ((Widgets_Widget)this).Width() - 2 * Config.ScaleFactor() - this.ScrollerWidth() : ((Widgets_Widget)this).Height() - 2 * Config.ScaleFactor() - this.ScrollerHeight();
        return (int)Math.floor((double)(this.i - this.min) / (double)(this.max - this.min) * (double)n);
    }

    public final void Draw(int n, int n2, boolean bl) {
        int[] nArray = this.active && bl ? ScrollBarWidget.selected : ScrollBarWidget.scroller;
        GUI.DrawBorderedRect(ScrollBarWidget.border, n, n2, ((Widgets_Widget)this).Width(), ((Widgets_Widget)this).Height(), Config.ScaleFactor());
        if (this.horizontal) {
            GUI.DrawBorderedRect(nArray, n + Config.ScaleFactor() + this.ScrollerShift(), n2 + Config.ScaleFactor(), this.ScrollerWidth(), this.ScrollerHeight(), Config.ScaleFactor());
        } else {
            GUI.DrawBorderedRect(nArray, n + Config.ScaleFactor(), n2 + Config.ScaleFactor() + this.ScrollerShift(), this.ScrollerWidth(), this.ScrollerHeight(), Config.ScaleFactor());
        }
    }

    public final int Width() {
        if (this.horizontal) {
            return this.length;
        }
        return Config.tileSize - 2 * Config.ScaleFactor();
    }

    public final int Height() {
        if (this.horizontal) {
            return Config.tileSize - 2 * Config.ScaleFactor();
        }
        return this.length;
    }
}

