OPTION BINARY
ALIGN OFF

TRUE = #FF
FALSE = #00

START_PLX = 28
START_PLY = 24
PL_SZX = 7
PL_SZY = 8
PL_BULLET_X = 3
PL_BULLET_Y = 0
PL_BULLET_SY = 2
PL_BULLET_SPEED = 2
MAX_STARS = 8;Изменить на метке Var_starsTXY!
MAX_ENEMY = 4;Изменить на метке Var_enemyTXY!
MAX_ENEMY_BULLETS = 8;Изменить на метке Var_enemyBullet!
ENEMY_SZX = 8
ENEMY_SZY = 8
EN_BULLET_SY = 2
EN_BULLET_SPEED = 2

EN1_BULLET_X = 3
EN1_BULLET_Y = 6

EN2_BULLET1_X = 2
EN2_BULLET1_Y = 8
EN2_BULLET2_X = 5
EN2_BULLET2_Y = 8

EN3_BULLET1_X = 1
EN3_BULLET1_Y = 8
EN3_BULLET2_X = 6
EN3_BULLET2_Y = 8
SCRx = 64
SCRy = 32

MainMenu:
 CLS
 LD I, spriteLogo0
 LD V0, 0
 LD V1, 0
 LD V2, 0
 LD V3, 0
 DrawMenuLogoLoop:
  DRW V0, V1, 14
  
  LD I, spriteLogo0
  ADD V2, 14
  ADD I, V2

  ADD V0, 8

  ADD V3, 1
 SE V3, 8
  JP DrawMenuLogoLoop

 CALL DrawStrNewGameCode

 LD VA, 0
 MainMenuLoop:
  SNE VA, 0
   CALL DrawStrNewGameCode
 
  LD V0, 5

  SKNP V0
   JP MainMenuKeyNewGame
  RET_MainMenuKeyNewGame

  LD V0, 30
  LD DT, V0
  DelayMenuDraw:
   LD V0, DT
  SE V0, 0
   JP DelayMenuDraw
JP MainMenuLoop

MainMenuKeyNewGame:
 SNE VA, 0
   JP NewGame
JP RET_MainMenuKeyNewGame

DrawStrNewGameCode:
 ;Рисуем строку "NewGame"
 LD I, strNewGame
 LD V1, 15;X
 LD V2, 17;Y
 LD V4, 0;Символ строки
 LD V3, 0;Счётчик
 strNewGameLen = 7
 drawNewGameStrLoop:
  LD V0, [I];Загружаем смещение символа

  ;Получаем адрес буквы
  LD I, spriteFONT1
  ADD I, V0

  ;Рисуем
  DRW V1, V2, 5

  ;Получаем адрес следующего смещения
  LD I, strNewGame
  ADD V4, 1
  ADD I, V4

  ;Двигаем X-координату буквы
  ADD V1, 5

  ADD V3, 1
 SE V3, strNewGameLen
  JP drawNewGameStrLoop
RET

NewGame:
 ;Стартовое положение игрока
 LD I, Var_plx
 LD V1, [I]

 LD V0, START_PLX
 LD V1, START_PLY

 LD I, Var_plx
 LD [I], V1

 ;Обнуление пуль игрока
 LD I, Var_plbc
 LD V0, [I]

 LD V0, FALSE

 LD I, Var_plbc
 LD [I], V1

 ;Обнуление врагов
 LD I, Var_enemyTXY
 LD V4, 0
 LD V3, 0
 EnemyENull:
  LD V0, 0

  LD [I], V0

  LD I, Var_enemyTXY
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY
  JP EnemyENull

 ;Обнуление пуль врагов
 LD I, Var_enemyBullet
 LD V4, 0
 LD V3, 0
 EnBullNullLoop:
  LD V0, 0

  LD [I], V0

  LD I, Var_enemyBullet
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY_BULLETS
  JP EnBullNullLoop

 CALL RandStars
JP GameCycle


RandStars:
 LD I, Var_starsTXY
 LD V5, 0
 LD V4, 0
 RandStarLoop:
  RND V0, SCRx-1
  RND V1, SCRy-1

  LD [I], V1

  ;Получаем адрес следущей звезды
  LD I, Var_starsTXY
  ADD V5, 2
  ADD I, V5

  ADD V4, 1
 SE V4, MAX_STARS
  JP RandStarLoop
RET

GameOver:
 CLS
 LD VE, 0
 
 ;Рисуем строку "GameOver"
 LD I, strGameOver
 LD V1, 12;X
 LD V2, 10;Y
 LD V4, 0;Символ строки
 LD V3, 0;Счётчик
 strGameOverLen = 8
 drawGameOverStrLoop:
  LD V0, [I];Загружаем смещение символа

  ;Получаем адрес буквы
  LD I, spriteFONT1
  ADD I, V0

  ;Рисуем
  DRW V1, V2, 5

  ;Получаем адрес следующего смещения
  LD I, strGameOver
  ADD V4, 1
  ADD I, V4

  ;Двигаем X-координату буквы
  ADD V1, 5

  ADD V3, 1
 SE V3, strGameOverLen
  JP drawGameOverStrLoop

 LD V0, 60
 LD DT, V0
 DelayGameOver:
  LD V0, DT
 SE V0, 0
  JP DelayGameOver
 
 LD V0, K
JP MainMenu
 
GameCycle:
 CALL KeyHandler
 CALL RndCreateEnemy
 CALL UPDAI
 CALL UPD_Enbullet
  SNE VE, TRUE
   JP GameOver
 CALL UPD_PLbullet
 CALL StarScroll
 CALL DrawGame
JP GameCycle

UPDAI:
 LD I, Var_enemyTXY
 LD V4, 0
 LD V3, 0
 UPDAI_LOOP:
  LD V2, [I]

  SNE V0, 1
   JP UPDAI_1
  SNE V0, 2
   JP UPDAI_2
  SNE V0, 3
   JP UPDAI_3
  END_UPDAI_SWICH:

  LD I, Var_enemyTXY
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY
  JP UPDAI_LOOP
RET

UPDAI_3:
 RND VC, 3

 SNE VC, 0
  JP AI3_EnToLeft
 SNE VC, 3
  JP AI3_EnToRight
 RET_AI3_EnTo:

 LD I, Var_enemyTXY
 ADD I, V4
 LD [I], V2

 RND VA, 7
 SNE VA, 0
  CALL AI3_CRbullet

JP END_UPDAI_SWICH

AI3_EnToLeft:
 ADD V1, #FF;(-1)
 SNE V1, #FF
  LD V1, 0
JP RET_AI3_EnTo

AI3_EnToRight:
 ADD V1, 1;
 SNE V1, SCRx-ENEMY_SZX+1
  LD V1, SCRx-ENEMY_SZX
JP RET_AI3_EnTo

AI3_CRbullet:
 LD V5, V0
 LD V6, V1
 LD V7, V2
 LD V8, V3
 LD V9, V4

 ADD V1, EN3_BULLET1_X
 ADD V2, EN3_BULLET1_Y
 LD VA, EN_BULLET_SY
 SUB V2, VA
 CALL CreateEnemyBullet

 LD V1, V6
 LD V2, V7
 ADD V1, EN3_BULLET2_X
 ADD V2, EN3_BULLET2_Y
 LD VA, EN_BULLET_SY
 SUB V2, VA
 CALL CreateEnemyBullet

 LD V0, V5
 LD V1, V6
 LD V2, V7
 LD V3, V8
 LD V4, V9
RET

UPDAI_2:
 RND VC, 3

 SNE VC, 0
  JP AI2_EnToLeft
 SNE VC, 3
  JP AI2_EnToRight
 RET_AI2_EnTo:

 LD I, Var_enemyTXY
 ADD I, V4
 LD [I], V2

 RND VA, 7
 SNE VA, 0
  CALL AI2_CRbullet

JP END_UPDAI_SWICH

AI2_EnToLeft:
 ADD V1, #FF;(-1)
 SNE V1, #FF
  LD V1, 0
JP RET_AI2_EnTo

AI2_EnToRight:
 ADD V1, 1;
 SNE V1, SCRx-ENEMY_SZX+1
  LD V1, SCRx-ENEMY_SZX
JP RET_AI2_EnTo

AI2_CRbullet:
 LD V5, V0
 LD V6, V1
 LD V7, V2
 LD V8, V3
 LD V9, V4

 ADD V1, EN2_BULLET1_X
 ADD V2, EN2_BULLET1_Y
 LD VA, EN_BULLET_SY
 SUB V2, VA
 CALL CreateEnemyBullet

 LD V1, V6
 LD V2, V7
 ADD V1, EN2_BULLET2_X
 ADD V2, EN2_BULLET2_Y
 LD VA, EN_BULLET_SY
 SUB V2, VA
 CALL CreateEnemyBullet

 LD V0, V5
 LD V1, V6
 LD V2, V7
 LD V3, V8
 LD V4, V9
RET

UPDAI_1:
 RND VC, 3

 SNE VC, 0
  JP AI1_EnToLeft
 SNE VC, 3
  JP AI1_EnToRight
 RET_AI1_EnTo:

 LD I, Var_enemyTXY
 ADD I, V4
 LD [I], V2

 RND VA, 7
 SNE VA, 0
  CALL AI1_CRbullet

JP END_UPDAI_SWICH

AI1_EnToLeft:
 ADD V1, #FF;(-1)
 SNE V1, #FF
  LD V1, 0
JP RET_AI1_EnTo

AI1_EnToRight:
 ADD V1, 1;
 SNE V1, SCRx-ENEMY_SZX+1
  LD V1, SCRx-ENEMY_SZX
JP RET_AI1_EnTo

AI1_CRbullet:
 LD V5, V0
 LD V6, V1
 LD V7, V2
 LD V8, V3
 LD V9, V4

 ADD V1, EN1_BULLET_X
 ADD V2, EN1_BULLET_Y
 LD VA, EN_BULLET_SY
 SUB V2, VA
 CALL CreateEnemyBullet

 LD V0, V5
 LD V1, V6
 LD V2, V7
 LD V3, V8
 LD V4, V9
RET

CreateEnemyBullet:
 LD I, Var_enemyBullet
 LD V4, 0
 LD V3, 0
 CreateEnemyBulletLoop:
  LD v0, [I]

  SE V0, TRUE
   JP CreateEnemyBulletProc

  LD I, Var_enemyBullet
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY_BULLETS
  JP CreateEnemyBulletLoop
RET

CreateEnemyBulletProc:
 LD V0, TRUE
 
 LD I, Var_enemyBullet
 ADD I, V4

 LD [I], V2
RET

RndCreateEnemy:
 RND V0, 7
 SNE V0, 0
  CALL FCreateEnemy
RET

UPD_Enbullet:
 LD I, Var_enemyBullet
 LD V4, 0
 LD V3, 0
 EnBulletUPDLoop:
  LD V2, [I]

  SE V0, FALSE
   CALL UPD_Enbullet_proc

  SNE VE, TRUE
   RET

  LD I, Var_enemyBullet
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY_BULLETS
  JP EnBulletUPDLoop
RET

UPD_Enbullet_proc
 LD V5, 0
 UPD_Enbullet_proc_loop:
  SE V0, FALSE
   CALL ScrollEnBullet

  SE V0, FALSE
   CALL CollEnBullet

  SNE VB, 1
   LD VE, TRUE
  SNE VB, 1
   RET

  ADD V5, 1
 SE V5, EN_BULLET_SPEED
  JP UPD_Enbullet_proc_loop
RET

ScrollEnBullet:
 ADD V2, 1
 SNE V2, SCRy
  LD V0, FALSE

 LD I, Var_enemyBullet
 ADD I, V4
 LD [I], V2
RET

CollEnBullet:
 LD V6, V0
 LD V7, V1
 LD V8, V2

 LD I, Var_plx
 LD V1, [I]

 LD VA, V0
 SUB VA, V7
 LD VB, VF

 LD VA, V0
 ADD VA, PL_SZX
 SUBN VA, V7
 AND VB, VF

 LD VA, V1
 SUB VA, V8
 AND VB, VF

 LD VA, V1
 ADD VA, PL_SZY
 SUBN VA, V8
 AND VB, VF

 LD V0, V6
 LD V1, V7
 LD V2, V8
RET

UPD_PLbullet:
 LD V8, 0
 PlBulletSpeedLoop:
  LD I, Var_plbc
  LD V2, [I]

  SNE V0, TRUE
   CALL ScrollPlBullet

  SNE V0, TRUE
   CALL CollPlBEn

  SE V0, TRUE
   RET

  ADD V8, 1
 SE V8, PL_BULLET_SPEED
  JP PlBulletSpeedLoop
RET

CollPlBEn:
 ;Сохраняем состояние пули
 LD V5, V1
 LD V6, V2
 LD V7, V0
 ;Загружаем врагов
 LD I, Var_enemyTXY
 LD V4, 0
 LD VB, 0
 LD V3, 0
 CollPlBEnLoop:
  LD V2, [I]

  ;Проверяем существование врага и коллизию
  SE V0, 0
   CALL CollPlBEnC

  ;Убиваем врага и пулю
  SE VB, 0
   JP SaveCollPlBEn

  ;Вычисляем адрес следущего врага
  LD I, Var_enemyTXY
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY
  JP CollPlBEnLoop

 LD V0, V7
RET

SaveCollPlBEn:
 ;Вычисляем адрес текущего врага, убиваем и сохраняем
  LD I, Var_enemyTXY
  ADD I, V4
  
  LD V0, 0
  LD [I], V0

 ;Убираем пулю и сохраняем
  LD I, Var_plbc
  LD [I], V0

 ;Выходим из CollPlBEn
RET

CollPlBEnC:
 LD VA, V1
 SUB VA, V5
 LD VB, VF

 LD VA, V1
 ADD VA, ENEMY_SZX
 SUBN VA, V5
 AND VB, VF

 LD VA, V2
 SUB VA, V6
 AND VB, VF

 LD VA, V2
 ADD VA, ENEMY_SZY
 SUBN VA, V6
 AND VB, VF
RET

ScrollPlBullet:
 ADD V2, #FF;(-1)

 SNE V2, #FF
  LD V0, FALSE

 LD I, Var_plbc
 LD [I], V2
RET

StarScroll:
 LD I, Var_starsTXY
 LD V4, 0
 LD V3, 0
 SScrLoop:
  ;Загружаеи переменные - X, Y
  LD V1, [I]

  ADD V1, 1
  SNE V1, SCRy
   CALL NewStar

  ;Получение адреса текущей звезды и сохранение
  LD I, Var_starsTXY
  ADD I, V4
  LD [I], V1
  
  ;Получение адреса следущей звезды
  LD I, Var_starsTXY
  ADD V4, 2
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_STARS
  JP SScrLoop
RET

NewStar:
 RND V0, SCRx-1
 LD V1, 0;
RET

DrawGame:
 ;Отчистка экрана
 CLS

 ;Нарисовать игрока
 LD I, Var_plx
 LD V1, [I];Загружаем координаты
 LD I, SpritePL
 DRW V0, V1, PL_SZY

 ;Нарисовать пулю игрока
 LD I, Var_plbc
 LD V2, [I]
 SNE V0, TRUE
  CALL DrawBullet

 ;Нарисовать врагов
 LD I, Var_enemyTXY
 LD V5, ENEMY_SZY
 LD V4, 0
 LD V3, 0
 DrawEnemyLoop:
  LD V2, [I]
  
  SE V0, 0
   CALL DrawEnemy

  LD I, Var_enemyTXY
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY
  JP DrawEnemyLoop

 ;Нарисовать пули врагов
 LD I, Var_enemyBullet
 LD V4, 0
 LD V3, 0
 DrawEnemyBulletLoop:
  LD v2, [I]

  SE V0, FALSE
   CALL DrawEnemyBullet

  LD I, Var_enemyBullet
  ADD V4, 3
  ADD I, V4

  ADD V3, 1
 SE V3, MAX_ENEMY_BULLETS
  JP DrawEnemyBulletLoop

 ;Нарисовать звёзды
 LD I, Var_starsTXY
 LD V5, 0
 LD V4, 0
 DrawStarLoop:
  LD V1, [I];Загружаеи переменные - X, y
   
  LD I, SpriteStar
  DRW V0, V1, 1

  ;Получение адреса следущей звезды
  LD I, Var_starsTXY
  ADD V5, 2
  ADD I, V5

  ADD V4, 1
 SE V4, MAX_STARS
  JP DrawStarLoop
RET

DrawEnemyBullet:
 LD I, SpriteBullet
 DRW V1, V2, EN_BULLET_SY
RET

DrawEnemy:
 LD I, SpriteEnemy1-ENEMY_SZY

 LD V6, 0
 EnALoop:
  ADD I, V5
 
  ADD V6, 1
 SE V6, V0
  JP EnALoop

 DRW V1, V2, ENEMY_SZY
RET

DrawBullet:
 LD I, SpriteBullet
 DRW V1, V2, PL_BULLET_SY
RET

KeyHandler:
 ;Клавиша 2/вверх
 LD V3, 2
 SKNP V3
  CALL KeyUp

 ;Клавиша 8/вниз
 LD V3, 8
 SKNP V3
  CALL KeyDown

 ;Клавиша 4/влево
 LD V3, 4
 SKNP V3
  CALL KeyLeft

 ;Клавиша 6/вправо
 LD V3, 6
 SKNP V3
  CALL KeyRight

 ;Клавиша 5/огонь
 LD V3, 5
 SKNP V3
  CALL KeyFire
RET

FCreateEnemy:
 LD I, Var_enemyTXY
 LD V4, 0
 LD V3, 0
 CrEnemyLoop:
  LD V2, [I]
  SNE V0, 0
   JP CreateEnemy

  LD I, Var_enemyTXY
  ADD V4, 3
  ADD I, V4
  
  ADD V3, 1
 SE V3, MAX_ENEMY
  JP CrEnemyLoop
RET

CreateEnemy:
 RND V0, 3

 RND V1, SCRx-1
 LD V2, 0

 ;Получаем адрес текущей ячейки и сохраняем.
 LD I, Var_enemyTXY
 ADD I, V4
 LD [I], V2
RET ;выход из FCreateEnemy

KeyFire:
 LD I, Var_plbc
 LD V2, [I]
 SNE V0, FALSE
  CALL CreateBullet
RET

CreateBullet:
 LD I, Var_plx-1
 LD V2, [I]

 LD V0, TRUE
 ADD V1, PL_BULLET_X
 ADD V2, PL_BULLET_Y

 LD I, Var_plbc
 LD [I], V2
RET

KeyUp:
 ;Загружаем координаты игрока
 LD I, Var_ply
 LD V0, [I]
 ;Двигаем игрока вверх
 ADD V0, #FF;оптимизация - при переполнении число становится меньше.
 ;Проверка границы экрана
 SNE V0, #FF
  LD V0, 0
 ;Сохраняем переменные
 LD I, Var_ply;без этого вылезают баги, регистр инкрементируется.
 LD [I], V0
RET

KeyDown:
 ;Загружаем координаты игрока
 LD I, Var_ply
 LD V0, [I]
 ;Двигаем игрока вниз
 ADD V0, 1
 ;Проверка границы экрана
 SNE V0, (SCRy + 1 - PL_SZY)
  LD V0, (SCRy - PL_SZY)
 ;Сохраняем переменные
 LD I, Var_ply
 LD [I], V0
RET

KeyLeft:
 ;Загружаем координаты игрока
 LD I, Var_plx
 LD V0, [I]
 ;Двигаем игрока влево
 ADD V0, #FF
 ;Проверка границы экрана
 SNE V0, #FF
  LD V0, 0
 ;Сохраняем переменные
 LD I, Var_plx
 LD [I], V0
RET

KeyRight:
 ;Загружаем координаты игрока
 LD I, Var_plx
 LD V0, [I]
 ;Двигаем игрока вправо
 ADD V0, 1
 ;Проверка границы экрана
 SNE V0, (SCRx + 1 - PL_SZX)
  LD V0, (SCRx - PL_SZX)
 ;Сохраняем переменные
 LD I, Var_plx
 LD [I], V0
RET

;===[Variables]===;
Var_plx:
 db 0
Var_ply:
 db 0

Var_plbc:
 db 0
Var_plbx:
 db 0
Var_plby:
 db 0

Var_starsTXY:
 ORG ? + (2 * 8)

Var_enemyTXY:
 ORG ? + (3 * 4)

Var_enemyBullet:
 ORG ? + (3 * 8)

SpritePL:
 db $...1....
 db $..1.1...
 db $..1.1...
 db $.11111..
 db $.11111..
 db $1111111.
 db $111.111.
 db $1..1..1.

SpriteStar:
 db $1.......

SpriteBullet:
 db $1.......
 db $1.......

SpriteEnemy1:
 db $1.1.1.1.
 db $.1...1..
 db $1.1.1.1.
 db $1111111.
 db $1111111.
 db $1111111.
 db $.11.11..
 db $..1.1...

SpriteEnemy2:
 db $..1..1..
 db $.111111.
 db $11111111
 db $11.11.11
 db $1......1
 db $.1....1.
 db $..1..1..
 db $..1..1..

SpriteEnemy3:
 db $...11...
 db $...11...
 db $.1.11.1.
 db $.111111.
 db $11111111
 db $111..111
 db $1..11..1
 db $.1....1.

spriteFONT1:
 db $.11.....
 db $1..1....
 db $1111....
 db $1..1....
 db $1..1....
spriteFONT2:
 db $111.....
 db $1..1....
 db $111.....
 db $1..1....
 db $111.....
spriteFONT3:
 db $1111....
 db $1.......
 db $1.......
 db $1.......
 db $1111....
spriteFONT4:
 db $111.....
 db $1..1....
 db $1..1....
 db $1..1....
 db $111.....
spriteFONT5:
 db $1111....
 db $1.......
 db $1111....
 db $1.......
 db $1111....
spriteFONT6:
 db $1111....
 db $1.......
 db $111.....
 db $1.......
 db $1.......
spriteFONT7:
 db $.111....
 db $1.......
 db $1.11....
 db $1..1....
 db $.111....
spriteFONT8:
 db $1..1....
 db $1..1....
 db $1111....
 db $1..1....
 db $1..1....
spriteFONT9:
 db $1111....
 db $.11.....
 db $.11.....
 db $.11.....
 db $1111....
spriteFONT10:
 db $1111....
 db $.11.....
 db $.11.....
 db $.11.....
 db $11......
spriteFONT11:
 db $1..1....
 db $1.1.....
 db $11......
 db $1.1.....
 db $1..1....
spriteFONT12:
 db $1.......
 db $1.......
 db $1.......
 db $1.......
 db $1111....
spriteFONT13:
 db $1..1....
 db $1111....
 db $1..1....
 db $1..1....
 db $1..1....
spriteFONT14:
 db $1..1....
 db $11.1....
 db $1.11....
 db $1..1....
 db $1..1....
spriteFONT15:
 db $1111....
 db $1..1....
 db $1..1....
 db $1..1....
 db $1111....
spriteFONT16:
 db $1111....
 db $1..1....
 db $1111....
 db $1.......
 db $1.......
spriteFONT17:
 db $.11.....
 db $1..1....
 db $1..1....
 db $1.11....
 db $.111....
spriteFONT18:
 db $111.....
 db $1..1....
 db $111.....
 db $1.1.....
 db $1..1....
spriteFONT19:
 db $.111....
 db $1.......
 db $.11.....
 db $...1....
 db $111.....
spriteFONT20:
 db $1111....
 db $.11.....
 db $.11.....
 db $.11.....
 db $.11.....
spriteFONT21:
 db $1..1....
 db $1..1....
 db $1..1....
 db $1..1....
 db $.11.....
spriteFONT22:
 db $1..1....
 db $1..1....
 db $1..1....
 db $.11.....
 db $.1......
spriteFONT23:
 db $1..1....
 db $1..1....
 db $1..1....
 db $1111....
 db $1..1....
spriteFONT24:
 db $1..1....
 db $1..1....
 db $.11.....
 db $1..1....
 db $1..1....
spriteFONT25:
 db $1..1....
 db $1..1....
 db $.11.....
 db $.11.....
 db $.11.....
spriteFONT26:
 db $1111....
 db $...1....
 db $.11....
 db $1.......
 db $1111....

spriteNUM0:
 db $1111....
 db $1..1....
 db $1..1...
 db $1..1....
 db $1111....
spriteNUM1:
 db $..1.....
 db $111.....
 db $.11....
 db $.11.....
 db $1111....
spriteNUM2:
 db $1111....
 db $...1....
 db $1111...
 db $1.......
 db $1111....
spriteNUM3:
 db $1111....
 db $...1....
 db $1111...
 db $...1....
 db $1111....
spriteNUM4:
 db $1..1....
 db $1..1....
 db $1111...
 db $...1....
 db $...1....
spriteNUM5:
 db $1111....
 db $1.......
 db $1111...
 db $...1....
 db $1111....
spriteNUM6:
 db $1111....
 db $1.......
 db $1111...
 db $1..1....
 db $1111....
spriteNUM7:
 db $1111....
 db $...1....
 db $...1...
 db $...1....
 db $...1....
spriteNUM8:
 db $1111....
 db $1..1....
 db $1111...
 db $1..1....
 db $1111....
spriteNUM9:
 db $1111....
 db $1..1....
 db $1111...
 db $...1....
 db $1111....

spriteLogo0:
 db $........
 db $........
 db $........
 db $........
 db $........
 db $........
 db $........
 db $........
 db $.1111111
 db $.11.....
 db $.1111111
 db $.11.....
 db $.1111111
 db $........

spriteLogo1:
 db $........
 db $.1111111
 db $.11.....
 db $.1111111
 db $........
 db $.1111111
 db $........
 db $........
 db $1......1
 db $.1....11
 db $11...11.
 db $.1..111.
 db $11..11..
 db $........

spriteLogo2:
 db $........
 db $111..111
 db $.....111
 db $111.....
 db $.11.....
 db $111.....
 db $........
 db $........
 db $11.....1
 db $.11....1
 db $..11....
 db $1.111...
 db $...11...
 db $........

spriteLogo3:
 db $........
 db $1111111.
 db $1111111.
 db $.11.....
 db $.11.....
 db $.11.....
 db $........
 db $........
 db $1111111.
 db $1111111.
 db $..11....
 db $..11....
 db $..11....
 db $........

spriteLogo4:
 db $........
 db $....111.
 db $...11.11
 db $..11...1
 db $.111.1.1
 db $.11.....
 db $........
 db $........
 db $.1111111
 db $.1111111
 db $....11..
 db $....11..
 db $....11..
 db $........

spriteLogo5:
 db $........
 db $....1111
 db $....1111
 db $1...1111
 db $11..11..
 db $11..11..
 db $........
 db $........
 db $1..11...
 db $1..11...
 db $...11...
 db $...11...
 db $...11111
 db $........

spriteLogo6:
 db $........
 db $111111..
 db $1...11..
 db $1111....
 db $..111...
 db $....11..
 db $........
 db $........
 db $.....111
 db $.....11.
 db $.....111
 db $.....11.
 db $111..111
 db $........

spriteLogo7:
 db $........
 db $........
 db $........
 db $........
 db $........
 db $........
 db $........
 db $........
 db $111111..
 db $........
 db $111111..
 db $........
 db $111111..
 db $........

strGameOver:
 db 30
 db 0
 db 60
 db 20

 db 70
 db 105
 db 20
 db 85

strNewGame:
 db 65
 db 20
 db 110

 db 30
 db 0
 db 60
 db 20

